use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear

gen big6 = 0 
replace big6 = 1 if (name == "citi" | name == "gs" | name == "wf" | name == "jpm" | name == "ms" | name == "baml") 
keep if big6 == 1

gen implied_minus_market = impvol - market_imp 
gen implied_div_market = impvol/market_imp 
gen vol_minus_market = vol-market_vol
gen vol_div_market = vol/market_vol 

**** compute yearly averages 
by year, sort: egen mean_beta_annual = mean(beta)
by year, sort: egen mean_vol_annual = mean(vol)
by year, sort: egen mean_vol_minus_market_annual = mean(vol_minus_market)
by year, sort: egen mean_vol_div_market_annual = mean(vol_div_market)
by year, sort: egen mean_impvol_annual = mean(impvol)
by year, sort: egen mean_impvol_minus_market_annual = mean(implied_minus_market)
by year, sort: egen mean_impvol_div_market_annual = mean(implied_div_market)
by year, sort: egen mean_cds_annual = mean(cds)
by year, sort: egen mean_ptb_annual = mean(ptb)
by year, sort: gen test_year_annual = _n
replace test_year_annual = 0 if test_year_annual != 1
br year mean_beta_annual mean_vol_annual mean_vol_minus_market_annual mean_impvol_annual mean_impvol_div_market_annual mean_cds_annual mean_ptb_annual if test_year_annual == 1

keep if test_year_annual == 1 
keep if year>= 2002
keep if year<2016 

save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack_december_2016.dta", replace



****** fix this one 
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack_december_2016.dta", clear

cd "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Figures_EPS"


*br year mean_beta_annual mean_vol_annual mean_vol_div_market_annual mean_imp_div_market_annual mean_implied_annual mean_cds_annual if output_indicator == 1 

summarize mean_beta_annual 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter mean_beta_annual year, legend(off) xlab(2002(2)2015) ytitle("Beta")
graph export beta_big6.eps, as(eps) replace
graph export beta_big6.png, replace


summarize mean_vol_annual 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter mean_vol_annual year, legend(off) xlab(2002(2)2015) ytitle("Volatility") 

graph export vol_big6.eps, as(eps) replace
graph export vol_big6.png, replace

summarize mean_vol_div_market_annual 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter mean_vol_div_market_annual year, legend(off) xlab(2004(2)2015) ytitle("Volatility/Market Volatility")
graph export vol_div_mkt_big6.eps, as(eps) replace
graph export vol_divbig6.png, replace

summarize mean_impvol_div_market_annual 

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter mean_impvol_div_market_annual year if year>= 2004, legend(off) xlab(2004(2)2015) ytitle("Implied Volatility/Market Implied Volatility")
graph export imp_div_annual_big6.eps, as(eps) replace
graph export impdiv_big6.png, replace

summarize mean_cds_annual 
twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter mean_cds_annual year if year>= 2004, legend(off) xlab(2004(2)2015) ytitle("CDS Spread") 

graph export cds_big6.eps, as(eps) replace
graph export cds_big6.png, replace

summarize mean_impvol_annual

twoway scatteri 0 2007.8 0 2009.8 `=r(max)' 2009.8 `=r(max)' 2007.8 0 2007.8, recast(area) color(gray*0.3) ///
|| scatter mean_impvol_annual year if year>= 2004, legend(off) xlab(2004(2)2015) ytitle("Implied Volatility")

graph export implied_big6.eps, as(eps) replace
graph export impvol_big6.png, replace



